d("cartDetailView",['util',], function(UTIL,cartDetail) {

    return {
        extendCartDetailView: function() {
            CCRZ.subsc = _.extend(CCRZ.subsc||{});            

            CCRZ.pubSub.on("view:CartDetailView:refresh", function(cartView){
                CCRZ.subsc.cartDetailRemoting =  _.extend(CCRZ.RemoteInvocation,{ 
                    className : 'ORBCB2B_CartDetailController', 
                    sendEmailCart : function( reqData,callback){ 
                        this.invokeCtx('sendEmailCart', 
                            reqData,  
                            function(resp, evt){ 
                                if(callback){
                                    callback(resp,evt);
                                }            
                            }, 
                            { 
                                buffer:false, //this call will be executed by itself 
                                nmsp : false //defines that this is a call to a subscriber class 
                            } 
                        );//end invokeCtx call 
                    }
                });
                cartView.events["click #sendEmailBtnCustom"]  = "SendEmailCustom"; 

                cartView.SendEmailCustom = function(event){
                    console.log('override email cart');
                    var toAdd = $('#email_to').val();
                    var ccAdd = $('#email_cc').val();
                    var subject = $('#subject').val(); 
                    var description = $('#description').val(); 
                    let reqData ={}; 
                    if(CCRZ.currentCart.attributes.sfid)
                        reqData.cartId  = CCRZ.currentCart.attributes.sfid;
                    else
                        reqData.cartId  = processUrl('cartId');
                    reqData.toAdd  = toAdd;
                    reqData.ccAdd  = ccAdd;
                    reqData.subject  = subject;
                    reqData.description  = description;
                    reqData.lid  = CCRZ.pagevars.userLocale;
                    if(typeof reqData.cartId == 'undefined' || reqData.cartId==null || reqData.cartId==''){
                        return;
                    }
                    CCRZ.subsc.cartDetailRemoting.sendEmailCart(JSON.stringify(reqData),function(res,event){
                        if(event.status){
                            console.log(res);
                            $('#emailModal').modal('hide');
                            $('body').removeClass('modal-open');
                            $('.modal-backdrop').remove();
        
                        }
                    });
                }
                cartView.delegateEvents();
                checkCartforPrice(cartView);            
            });
        } 
    }
    function checkCartforPrice(view){
        let cartItems = view.model.get('ECartItemsS');
        let cartStatus = true;
        for(var item in cartItems.models){
            if (Object.prototype.hasOwnProperty.call(cartItems.models,item)) {
                console.log('item values: ' + cartItems.models[item].attributes.originalItemPrice);
                let values = cartItems.models[item].attributes;
                if(values.productType != 'Coupon' && (values.originalItemPrice <= 0 || values.originalItemPrice == null )){
                    cartStatus = false;
                }
            }
        }
        if(!cartStatus){
            $('.checkOutBtn').attr('disabled','disabled');
            CCRZ.pubSub.trigger("pageMessage", CCRZ.createPageMessage('WARN', "messagingSection-Error", 'CartNoPrice'));
        }
    }
});