d("MyAutoPayView",['ccrz', 'util','MyAutoPayModel'], function(CCRZ, UTIL,MyAutoPayModel){
    return{
        extendMyAutoPay: function(view){
            console.log('In Autopay')
            var isRefreshed = false;
            var newModel = new CCRZ.models.MyAutoPayModel();
            CCRZ.views.MyAutoPayView = CCRZ.CloudCrazeView.extend({
                /*templatePhone : CCRZ.util.template('MyAccount_AutoPay'),
                templateDesktop : CCRZ.util.template('MyAccount_AutoPay'),*/
                templateDesktop: CCRZ.util.template(CCRZ.uiProperties.MyAutoPayView.desktop.tmpl),
                templatePhone: CCRZ.util.template(CCRZ.uiProperties.MyAutoPayView.desktop.tmpl),           
                managedSubView : true,
                hasRendered: false,               
                mid: '',
                portalType: '',          
                viewName : "MyAutoPayView",
                loadStartCall : 'On load assigned text',
                events:{
                    "click #createAutoPay" : "createAutoPay",
                    "click .deleteAutoPay" : "deleteAutoPay",
                    "change #orbBusiness" : "getAPStoredPayments",
                    "change #portalType" : "setPortalType",
                    "change .storedPaymentSelection" : "setSelectedPayment"
                },
                initSetup : function(callback){
                    // alert('Rendering the view');              
                    console.log('gettin data');
                 //   debugger;
                    this.getExistingAutoPay();
                    this.getInvoiceTypes();
                    this.getJDECompanies();                    
                    callback();

                },
                renderPhone : function() {
                    this.$el.html(this.templatePhone(this));
                },
                renderDesktop : function() {
                    console.log('renderAuto');
                    this.$el.html(this.templateDesktop(this));
                },
                postRender : function(){
                    let _this = this;    
                    if(_this.portalType && _this.mid){
                        document.getElementById('portalType').value = _this.portalType;
                        document.getElementById('orbBusiness').value = _this.mid;  
                    }                                        
                },
                getInvoiceTypes : function(){
                 //   debugger;
                    let _this = this;
                    let model = new CCRZ.models.MyAutoPayModel();
                    let hasGen = false;                    
                    model.getInvoiceTypes(function(response,event){
                        if(response){
                            if(response.data){
                              //  debugger;
                                console.log(JSON.stringify(response.data));
                                response.data.forEach(element => {
                                    console.log('ele: ' + JSON.stringify(element));
                                    if(element.Invoice_Type__c == 'General'){
                                        console.log('has gen');
                                        hasGen = true;
                                    }                         
                                });                          
                                if(!hasGen){
                                    let gen = {
                                        Invoice_Type__c : 'General'
                                    }
                                    response.data.push(gen);                                    
                                }                            
                                _this.invoiceTypes = response.data;
                                _this.model.types = _this.invoiceTypes    
                                _this.render();                           
                            }
                        }
                    });
                },
                getJDECompanies : function(){
                    let _this = this;   
                    let model = new CCRZ.models.MyAutoPayModel();              
                    model.getJDECompanies(function(response,event){
                        if(response){
                            if(response.data){
                                console.log()
                                _this.midCompanies = response.data;
                                _this.model.companies = _this.midCompanies   
                                _this.render();                            
                            }
                        }
                    });
                },
                getExistingAutoPay : function(){
                    let _this = this;       
                    let model = new CCRZ.models.MyAutoPayModel();                           
                    _this.model.autoPayList = null;
                    model.getExistingAutoPay(function(response,event){
                        if(response){
                            if(response.data){
                                _this.autoPayList = response.data;
                                _this.model.autoPayList = _this.autoPayList;      
                                _this.hasRendered = false;
                                _this.render();                       
                            }
                        }
                    });
                },                   
                getAPStoredPayments : function(){
                 //   debugger;
                    let _this = this;
                    let model = new CCRZ.models.MyAutoPayModel();
                    console.log('getting Stored Payment');
                    let e = document.getElementById('orbBusiness');
                    _this.mid = e.value;
                    _this.company = e.options[e.selectedIndex].text;
                    _this.portalType = document.getElementById('portalType').value;
                    let reqData = {
                        mid : _this.mid
                    };
                    model.getStoredPayments(JSON.stringify(reqData),function(response,event){
                        if(response){
                            if(response.data){
                                console.log('setting Stored');
                                _this.model.noStored = null;
                                let tempList = [];
                                let finalStoredPayments = [];
                                tempList = response.data;
                                tempList.forEach(element => {
                                    let storedPay = {
                                        accountType : element.ccrz__AccountType__c,
                                        sfid : element.Id,
                                        accountNumber : element.ccrz__AccountNumber__c,
                                        subAccountNumber : element.ccrz__SubaccountNumber__c,
                                        expirationMonth : element.ccrz__ExpMonth__c,
                                        expirationYear : element.ccrz__ExpYear__c,                                        
                                        paymentType : element.ccrz__PaymentType__c
                                    }
                                    finalStoredPayments.push(storedPay);
                                });
                                _this.storedPay = finalStoredPayments;   
                                _this.render();  
                             //   debugger;
                                let type = document.getElementById('portalType').value = _this.portalType;
                                let comp = document.getElementById('orbBusiness').value = _this.mid;    
                            }
                            else{
                                console.log('no Stored Payments');
                                _this.model.noStored = 'There are no valid Stored Payments for this Company. Please create a Stored Payment in the My Wallet section of My Account.';   
                                console.log('Message: ' + _this.model.noStored);       
                                _this.render(); 
                            }
                        }
                    });
                },
                setPortalType : function(){
                    let _this = this;
                    _this.portalType = document.getElementById('portalType').value;
                    console.log('selected type: ' + _this.portalType);
                },
                
                setSelectedPayment : function(event){
                  //  debugger;
                    var _this = this;                    
                    var objLink = $(event.currentTarget);
                    var pid = objLink.data("id");
                    console.log('id: ' + pid);
                    console.log('checked? : ' + event.target.checked);
                    _this.stored = pid;
                    console.log("type: " +_this.portalType+" company: "+_this.company+" Stored: "+_this.stored);
                },
                createAutoPay : function(){
                    let _this = this;
                    let model = new CCRZ.models.MyAutoPayModel();                    
                    if(_this.company && _this.portalType && _this.stored){
                        let reqData = {
                            type : _this.portalType,
                            service : _this.company,
                            storedPayment: _this.stored
                        };
                        model.createAutoPay(JSON.stringify(reqData),function(response,event){
                            if(response){
                                if(response.success){
                                    alert('AutoPay Subscription Saved!');   
                                    _this.hasRendered = false;
                                    _this.model.types = false;
                                    _this.model.companies = false;
                                    _this.storedPay = false;
                                    _this.mid = false;
                                    _this.portalType = false;
                                    _this.getExistingAutoPay();
                                    _this.getInvoiceTypes();
                                    _this.getJDECompanies();                                  
                                    _this.render();    
                                }
                                else{
                                    if(response.data){
                                        alert(response.data);
                                    }
                                    else{
                                        alert('There was an error creating the Autopay Subscription. Please contact Orbcomm Support if the issue persist.');
                                    }                                   
                                }
                            }
                            else{
                                
                            }
                        });
            
                          
                    }
                    else{
                        alert('Please select a Portal Type, Company, and Stored Payment');
                    }
                   
                    /*model.getStoredPayments(JSON.stringify(reqData),function(response,event){
                        if(response){
                            if(response.data){                                
                                alert('AutoPay Subscription Saved!');                           
                            }
                        }
                    });*/
                },
                openDeleteModal: function(event) {
                    var objLink = $(event.currentTarget);
                    var pid = objLink.data("pid");
                    var modalData = {"pid": pid};
                    var modalView = new CCRZ.views.deleteModal();
                    modalView.render(modalData, function() {
                        $('#deleteMod_' + modalData.pid).modal({ keyboard: false, backdrop: 'static', show: true });
                    });
                },
                closeDeleteModal: function(event){
                    var objLink = $(event.currentTarget);
                    var pid = objLink.data("pid");
                    $("#deleteMod_" + pid).modal("hide");
                },
                deleteAutoPay: function(event) {
                    var _this = this; 
                    let model = new CCRZ.models.MyAutoPayModel();              
                    var objLink = $(event.currentTarget);
                    var pid = objLink.data("pid");
                    let reqData = {
                        apId : pid 
                    };                    
                    model.deleteAutoPay(JSON.stringify(reqData),function(response,event){
                        if(response){
                            if(response.success){
                                _this.hasRendered = false;
                                _this.getExistingAutoPay();
                                _this.render();  
                            }
                            else{
                                alert('There was an issue removing Autop Subscription.');
                            }
                        }
                        else{
                            alert("There was an issue removing the Autopay Subscription. Please contact Orbcomm if this issue persist.");
                        }
                    });                 
                }
            }); 
        }
    }  
});